<?php
defined ('_JEXEC') or die('Restricted access');
/**
 *
 *
 * @author Web-Mex
 * @version $Id: netDebit.php 2015-03-09
 * @package VirtueMart
 * @subpackage payment
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See /administrator/components/com_virtuemart/COPYRIGHT.php for copyright notices and details.
 *
 * http://virtuemart.org
 */
if (!class_exists ('vmPSPlugin')) {
	require(JPATH_VM_PLUGINS . DS . 'vmpsplugin.php');
}

class plgVmPaymentNetdebit extends vmPSPlugin {

	// instance of class
	public static $_this = FALSE;

	function __construct (& $subject, $config) {  ///Aufruf durch Warenkorb
	
		
		parent::__construct ($subject, $config);
				
		$this->_loggable = TRUE;
		$this->tableFields = array_keys ($this->getTableSQLFields ());
		$this->_tablepkey = 'id';
		$this->_tableId = 'id';
		$varsToPush = array('NETDEBIT_GATEWAY_SERVER'		 => array('0', 'int'),
		                    'NETDEBIT_EMAIL'         => array('', 'char'),
				            'NETDEBIT_SID'         => array('', 'char'),
							'NETDEBIT_CON'         => array('', 'char'),
							'NETDEBIT_PASSWORD'    => array('', 'char'),
							'NETDEBIT_PID'         => array('', 'char'),
							'payment_logos'        => array('', 'char'),
							'NETDEBIT_DEBUG'       =>	 array('', 'int'),
							'NETDEBIT_BUTTON'      => array('', 'int'),
							'NETDEBIT_STATUS'      => array('', 'char'),
							'NETDEBIT_RETURN' => array('', 'char')
		                                        
		);

		$this->setConfigParameterable ($this->_configTableFieldName, $varsToPush);
		
	}
	
	/**
	 * @return string
	 */
	public function getVmPluginCreateTableSQL () {
		

		return $this->createTableSQL ('Payment netDebit Table');
	}

	/**
	 * @return array
	 */
	function getTableSQLFields () {
		

		$SQLfields = array(
			'id'                                     => 'int(11) UNSIGNED NOT NULL AUTO_INCREMENT',
			'virtuemart_order_id'                    => 'int(1) UNSIGNED',
			'order_number'                           => ' char(64)',
			'virtuemart_paymentmethod_id'            => 'mediumint(1) UNSIGNED',
			'payment_name'                           => 'varchar(5000)',
				
			'payment_order_total'                    => 'decimal(15,5) NOT NULL DEFAULT \'0.00000\'',
			'payment_currency'                       => 'char(3) ',
			'netDebit_errorcode'            		 => 'char(10)',
			'netDebit_errormessage'                  => 'varchar(5000)',
			'netDebit_belegnr' 						 => 'char(128)',
			'netDebit_traceno'               		 => 'char(128)',
			'netDebit_payment_date'                  => 'char(28)',
				
			'netDebit_response_payment_status'       => 'char(50)'
		);
		
		return $SQLfields;
	}

	/**
	 * @param $cart
	 * @param $order
	 * @return bool|null
	 */
	function plgVmConfirmedOrder ($cart, $order) {
		
		if (!($method = $this->getVmPluginMethod ($order['details']['BT']->virtuemart_paymentmethod_id))) {
			return NULL; // Another method was selected, do nothing
		}  
		if (!$this->selectedThisElement ($method->payment_element)) {
			return FALSE;
		}
		$session = JFactory::getSession ();
		$return_context = $session->getId ();
		$this->logInfo ('plgVmConfirmedOrder order number: ' . $order['details']['BT']->order_number, 'message');

		if (!class_exists ('VirtueMartModelOrders')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
		}
		if (!class_exists ('VirtueMartModelCurrency')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'currency.php');
		}

		$address = ((isset($order['details']['ST'])) ? $order['details']['ST'] : $order['details']['BT']);

		if (!class_exists ('TableVendors')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'table' . DS . 'vendors.php');
		}
		
		$vendorModel = VmModel::getModel ('Vendor');
		$vendorModel->setId (1);
		$vendor = $vendorModel->getVendor ();
		$vendorModel->addImages ($vendor, 1);
		$this->getPaymentCurrency ($method);
		$q = 'SELECT `currency_code_3` FROM `#__virtuemart_currencies` WHERE `virtuemart_currency_id`="' . $method->payment_currency . '" ';
		$db = JFactory::getDBO ();
		$db->setQuery ($q);
		$currency_code_3 = $db->loadResult ();
		$paymentCurrency = CurrencyDisplay::getInstance ($method->payment_currency);
		$totalInPaymentCurrency = round ($paymentCurrency->convertCurrencyTo ($method->payment_currency, $order['details']['BT']->order_total, FALSE), 2);
		$cd = CurrencyDisplay::getInstance ($cart->pricesCurrency);
		if ($totalInPaymentCurrency <= 0) {
			vmInfo (JText::_ ('VMPAYMENT_NETDEBIT_PAYMENT_AMOUNT_INCORRECT'));
			return FALSE;
		}
		$netdebit_siteid = $this->_get_netdebit_sid ($method);
		$post_variables = Array(
			'shopid'     => $order['details']['BT']->order_number
		);

		// Prepare data that should be stored in the database
		$dbValues['order_number'] = $order['details']['BT']->order_number;
		$dbValues['payment_name'] = $this->renderPluginName ($method, $order);
		$dbValues['virtuemart_paymentmethod_id'] = $cart->virtuemart_paymentmethod_id;
		$dbValues['payment_currency'] = $method->payment_currency;
		$dbValues['payment_order_total'] = $totalInPaymentCurrency;
		
		$this->storePSPluginInternalData ($dbValues);
		
		$html = '<script type="text/javascript" SRC="http://www.fixport.de/secuSYS/NDCODE.php?F=';
		
		if (1 == $method->NETDEBIT_GATEWAY_SERVER) {
			
			$html .= '9090&amp;';
			
		}  else {
			$html .= '1000&amp;';
			
		}
		
		$html .= 'PID='.$method->NETDEBIT_PID.'&amp;';
		$html .= 'CON='.$method->NETDEBIT_CON.'&amp;';
		$html .= 'SID='.$method->NETDEBIT_SID.'&amp;';
		$html .= '" ></script>';
		$html .= '<div style="margin: auto; text-align: center;">';
		$html .= '<a href="#" onClick="javascript:GATE_NDV2_AMOUNT('."'";
		$html .= $order['details']['BT']->virtuemart_order_id; ///Order ID
		$html .= "','".$return_context."','1', '1', '0', '', '0','".$totalInPaymentCurrency;
		$html .= "', '9', '1', '";
		$html .= hash('md5', sprintf("%.2f",$totalInPaymentCurrency) . $method->NETDEBIT_PASSWORD);
		$html .= "'); return false;".'"'.'href="http://www.netdebit-payment.de" data-mce-onclick="">';
		
		if (1 == $method->NETDEBIT_BUTTON) {
		$html .= '<br/><img src="http://'.$_SERVER["HTTP_HOST"].'/images/stories/virtuemart/payment/netdebit-button.png" alt="Confirm" /><br/><br/>';
		} else {
		    $html .= '<span>'.JText::_ ('VMPAYMENT_NETDEBIT_CONFIRM').'</span><br/>';
		}
		$html .= '<img src="http://www.netdebit.de/payment/IMG/ND-Zert.png" alt="NetDebit" title="NetDebit" /></a><br/>';
		$html .= '<br/><a class="button" href="'.$method->NETDEBIT_RETURN.'" >'.JText::_ ('VMPAYMENT_NETDEBIT_RETURN_TEXT').'</a>';
		$html .= '</div>';
				
		$cart->_confirmDone = TRUE;
		$cart->_dataValidated = TRUE;
		$cart->setCartIntoSession ();
		$cart->emptyCart (); 
		JRequest::setVar ('html', $html);
	}

	/**
	 * @param $virtuemart_paymentmethod_id
	 * @param $paymentCurrencyId
	 * @return bool|null
	 */
	function plgVmgetPaymentCurrency ($virtuemart_paymentmethod_id, &$paymentCurrencyId) {

		if (!($method = $this->getVmPluginMethod ($virtuemart_paymentmethod_id))) {
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement ($method->payment_name)) {
			return FALSE;
		}
		$this->getPaymentCurrency ($method);
		$paymentCurrencyId = $method->payment_currency;
	}

	/**
	 * @param $html
	 * @return bool|null|string
	 */
	function plgVmOnPaymentResponseReceived (&$html) {

		
		if (!class_exists ('VirtueMartCart')) {
			require(JPATH_VM_SITE . DS . 'helpers' . DS . 'cart.php');
		}
		if (!class_exists ('shopFunctionsF')) {
			require(JPATH_VM_SITE . DS . 'helpers' . DS . 'shopfunctionsf.php');
		}
		if (!class_exists ('VirtueMartModelOrders')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
		}
		$virtuemart_paymentmethod_id = JRequest::getInt ('on', 0);
		if (!($method = $this->getVmPluginMethod ($virtuemart_paymentmethod_id))) {
			return NULL; // Another method was selected, do nothing
		}
		
		###Daten Einsammeln ####
		$_status = $_POST['Status'];
		/*----------------------------------------------------------------------
		 VAR1
		Enthält die OrderNumber aus virtueMart
		----------------------------------------------------------------------*/
		$_oid = $_POST['VAR1'];
			
		/*----------------------------------------------------------------------
		 BookingNumber, CustomerID
		Informationen, die mit der Bestellung gespeichert werden
		----------------------------------------------------------------------*/
		$_bn = $_POST['BookingNumber'];
		$_cid = $_POST['CustomerID'];
		$_pass = $_POST['GatePass'];
		
		/*----------------------------------------------------*/

		$message = "Data From NetDebit Plugin\r\nMessage:->\n";
		$message .= "Status_".$_status."\r\n";
		$message .= "oid_".$_oid."\r\n";
		$message .= "bn_".$_bn."\r\n";
		$message .= "cid_".$_cid."\r\n";
				// In case any of our lines are larger than 70 characters, we should use wordwrap()
		$message = wordwrap($message, 70, "\r\n");
		$mail = $method->NETDEBIT_EMAIL;
		$order_number = 9999 ;
		$virtuemart_order_id = $_oid;
				
		if (1 == $method->NETDEBIT_DEBUG) {
				
				echo "<h1>Debuger ist Eingeschaltet</h1>";
				print_r($method);
				echo $message;
				mail($mail, 'Netdebit-Payment-Plugin', $message);
						
		} else {
		
		####IP Check
	
		$ip = $_SERVER['REMOTE_ADDR'];
		if ( $ip != '213.69.111.70' &&
				$ip != '213.69.111.71' &&
				$ip != '213.69.234.74' &&
				$ip != '213.69.234.76' &&
				$ip != '195.126.100.14' )die("IP not allowed");
	
		}
		
			
		$modelOrder = VmModel::getModel ('orders');
		$order = array();
			
		if ($_status == '9') {
			$message .= "\r\nStatus storno ->".$_status;
			mail($mail, 'Netdebit-Payment-Plugin', $message);
			echo "Status".$_status.$message;
			
			$order['order_status'] = X;
			$order['comments'] = JText::sprintf ('Netdebit Status Storno', $order_number);
			$modelOrder->updateStatusForOneOrder ($virtuemart_order_id, $order, TRUE);
			
			die("Status storno");
		}
		
		if ($_status == '1') {
			$message .= "\r\nStatus refund ->".$_status;
			mail($mail, 'Netdebit-Payment-Plugin', $message);
			echo "Status".$_status.$message;
			$order['order_status'] = R;
			$order['comments'] = JText::sprintf ('Netdebit Status Refund', $order_number);
			$modelOrder->updateStatusForOneOrder ($virtuemart_order_id, $order, TRUE);
					
			die("Stauts refund");
		}
		
		$lang = JFactory::getLanguage ();
		$order['customer_notified'] = 1;
		$order['order_status'] = $method->NETDEBIT_STATUS;
		$order['comments'] = JText::sprintf ('Netdebit Zahlungsstatus Confirm', $order_number);
		$modelOrder->updateStatusForOneOrder ($virtuemart_order_id, $order, TRUE);
		
		
		/*--------------------Datenbank Update der bestellten Artikel ---------------------------*/
		/*
		$db = JFactory::getDBO();
		
		$query = $db->getQuery(true);
		
		$itemstat = new stdClass();
		 
		$itemstat->virtuemart_order_id =$db->getEscaped($_oid);
		 
		if ($_status == '0'){
			 
			$itemstat->order_status =$db->getEscaped('C');
			 
		} else {
			 
			$itemstat->order_status =$db->getEscaped('P');
		}
		
		
		
		try {
		
			$result = JFactory::getDbo()->updateObject('#__virtuemart_order_items', $itemstat, 'virtuemart_order_id');
		
		} catch (Exception $e) {
			 
			echo "<h1>Hat nicht funktioniert</h1>".$result."error_".$e;
		
			$message .= 'DB Update Fail->'.$result." error ->".$e;
		
			mail($mail, 'Netdebit-Payment-Plugin', $message);
			 
			die();
			// Catch the error.
		}	
		*/		
		
		echo "OK=100";
		
		exit();
		
		return TRUE;
	}

	/**
	 * @return bool|null
	 */
	function plgVmOnUserPaymentCancel () {

		if (!class_exists ('VirtueMartModelOrders')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
		}

		$order_number = JRequest::getString ('on', '');
		$virtuemart_paymentmethod_id = JRequest::getInt ('pm', '');
		if (empty($order_number) or empty($virtuemart_paymentmethod_id) or !$this->selectedThisByMethodId ($virtuemart_paymentmethod_id)) {
			return NULL;
		}
		if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber ($order_number))) {
			return NULL;
		}
		if (!($paymentTable = $this->getDataByOrderId ($virtuemart_order_id))) {
			return NULL;
		}

		VmInfo (Jtext::_ ('VMPAYMENT_NETDEBIT_PAYMENT_CANCELLED'));
		$session = JFactory::getSession ();
		$return_context = $session->getId ();
		if (strcmp ($paymentTable->inetcash_custom, $return_context) === 0) {
			$this->handlePaymentUserCancel ($virtuemart_order_id);
		}
		return TRUE;
	}

	

	/**
	 * @return bool|null
	 */
	function plgVmOnPaymentNotification () {

		return NULL;
	}


	/**
	 * @param $virtuemart_order_id
	 * @return mixed|string
	 */
	function _getTablepkeyValue ($virtuemart_order_id) {

		$db = JFactory::getDBO ();
		$q = 'SELECT ' . $this->_tablepkey . ' FROM `' . $this->_tablename . '` '
			. 'WHERE `virtuemart_order_id` = ' . $virtuemart_order_id;
		$db->setQuery ($q);

		if (!($pkey = $db->loadResult ())) {
			JError::raiseWarning (500, $db->getErrorMsg ());
			return '';
		}
		return $pkey;
	}


	function _get_netdebit_sid ($method) {

		return $method->NETDEBIT_SID;
	}
	


	/**
	 * @param VirtueMartCart $cart
	 * @param                $method
	 * @param                $cart_prices
	 * @return int
	 */
	function getCosts (VirtueMartCart $cart, $method, $cart_prices) {
		
				
		$method->cost_percent_total = 0;
		$method->cost_per_transaction = 0;
		
		if (preg_match ('/%$/', $method->cost_percent_total)) {
			$cost_percent_total = substr ($method->cost_percent_total, 0, -1);
		}
		else {
			$cost_percent_total = $method->cost_percent_total;
		}
		return ($method->cost_per_transaction + ($cart_prices['salesPrice'] * $cost_percent_total * 0.01));
	}

	/**
	 * Check if the payment conditions are fulfilled for this payment method
	 *
	 * @author: Valerie Isaksen
	 *
	 * @param $cart_prices: cart prices
	 * @param $payment
	 * @return true: if the conditions are fulfilled, false otherwise
	 *
	 */
	protected function checkConditions ($cart, $method, $cart_prices) {

		$this->convert ($method);
		
			

		$address = (($cart->ST == 0) ? $cart->BT : $cart->ST);

		$amount = $cart_prices['salesPrice'];
		$amount_cond = ($amount >= $method->min_amount AND $amount <= $method->max_amount
			OR
			($method->min_amount <= $amount AND ($method->max_amount == 0)));
		
		

		$countries = array();
		if (!empty($method->countries)) {
			if (!is_array ($method->countries)) {
				$countries[0] = $method->countries;
			}
			else {
				$countries = $method->countries;
			}
		}
		// probably did not gave his BT:ST address
		if (!is_array ($address)) {
			$address = array();
			$address['virtuemart_country_id'] = 0;
		}

		if (!isset($address['virtuemart_country_id'])) {
			$address['virtuemart_country_id'] = 0;
		}
		if (in_array ($address['virtuemart_country_id'], $countries) || count ($countries) == 0) {
			if ($amount_cond) {
				return TRUE;
			}
		}

		return FALSE;
	}

	/**
	 * @param $method
	 */
	function convert ($method) {

		$method->min_amount = 1;    //(float)$method->min_amount;
		$method->max_amount = 10000;//(float)$method->max_amount;
	}

	/**
	 * We must reimplement this triggers for joomla 1.7
	 */

	/**
	 * Create the table for this plugin if it does not yet exist.
	 * This functions checks if the called plugin is active one.
	 * When yes it is calling the standard method to create the tables
	 *
	 * @author Valérie Isaksen
	 *
	 */
	function plgVmOnStoreInstallPaymentPluginTable ($jplugin_id) {

		return $this->onStoreInstallPluginTable ($jplugin_id);
	}

	/**
	 * This event is fired after the payment method has been selected. It can be used to store
	 * additional payment info in the cart.
	 *
	 * @author Max Milbers
	 * @author Valérie isaksen
	 *
	 * @param VirtueMartCart $cart: the actual cart
	 * @return null if the payment was not selected, true if the data is valid, error message if the data is not vlaid
	 *
	 */
	public function plgVmOnSelectCheckPayment (VirtueMartCart $cart,  &$msg) {

		return $this->OnSelectCheck ($cart);
	}

	/**
	 * plgVmDisplayListFEPayment
	 * This event is fired to display the pluginmethods in the cart (edit shipment/payment) for exampel
	 *
	 * @param object  $cart Cart object
	 * @param integer $selected ID of the method selected
	 * @return boolean True on succes, false on failures, null when this plugin was not selected.
	 * On errors, JError::raiseWarning (or JError::raiseError) must be used to set a message.
	 *
	 * @author Valerie Isaksen
	 * @author Max Milbers
	 */
	public function plgVmDisplayListFEPayment (VirtueMartCart $cart, $selected = 0, &$htmlIn) {

		return $this->displayListFE ($cart, $selected, $htmlIn);
	}

	/**
		 * plgVmonSelectedCalculatePricePayment
		 * Calculate the price (value, tax_id) of the selected method
		 * It is called by the calculator
		 * This function does NOT to be reimplemented. If not reimplemented, then the default values from this function are taken.
		 * @author Valerie Isaksen
		 * @cart: VirtueMartCart the current cart
		 * @cart_prices: array the new cart prices
		 * @return null if the method was not selected, false if the shiiping rate is not valid any more, true otherwise
		 *
		 *
		 */

	/**
	 * @param VirtueMartCart $cart
	 * @param array          $cart_prices
	 * @param                $cart_prices_name
	 * @return bool|null
	 */
	public function plgVmonSelectedCalculatePricePayment (VirtueMartCart $cart, array &$cart_prices, &$cart_prices_name) {

		return $this->onSelectedCalculatePrice ($cart, $cart_prices, $cart_prices_name);
	}

	/**
	 * plgVmOnCheckAutomaticSelectedPayment
	 * Checks how many plugins are available. If only one, the user will not have the choice. Enter edit_xxx page
	 * The plugin must check first if it is the correct type
	 *
	 * @author Valerie Isaksen
	 * @param VirtueMartCart cart: the cart object
	 * @return null if no plugin was found, 0 if more then one plugin was found,  virtuemart_xxx_id if only one plugin is found
	 *
	 */
	function plgVmOnCheckAutomaticSelectedPayment (VirtueMartCart $cart, array $cart_prices = array(), &$paymentCounter) {

		return $this->onCheckAutomaticSelected ($cart, $cart_prices, $paymentCounter);
	}

	/**
	 * This method is fired when showing the order details in the frontend.
	 * It displays the method-specific data.
	 *
	 * @param integer $order_id The order ID
	 * @return mixed Null for methods that aren't active, text (HTML) otherwise
	 * @author Max Milbers
	 * @author Valerie Isaksen
	 */
	public function plgVmOnShowOrderFEPayment ($virtuemart_order_id, $virtuemart_paymentmethod_id, &$payment_name) {

		$this->onShowOrderFE ($virtuemart_order_id, $virtuemart_paymentmethod_id, $payment_name);
	}

	/**
	 * This event is fired during the checkout process. It can be used to validate the
	 * method data as entered by the user.
	 *
	 * @return boolean True when the data was valid, false otherwise. If the plugin is not activated, it should return null.
	 * @author Max Milbers

	public function plgVmOnCheckoutCheckDataPayment($psType, VirtueMartCart $cart) {
	return null;
	}
	 */

	/**
	 * This method is fired when showing when priting an Order
	 * It displays the the payment method-specific data.
	 *
	 * @param integer $_virtuemart_order_id The order ID
	 * @param integer $method_id  method used for this order
	 * @return mixed Null when for payment methods that were not selected, text (HTML) otherwise
	 * @author Valerie Isaksen
	 */
	function plgVmonShowOrderPrintPayment ($order_number, $method_id) {

		return $this->onShowOrderPrint ($order_number, $method_id);
	}

	/**
	 * Save updated order data to the method specific table
	 *
	 * @param array $_formData Form data
	 * @return mixed, True on success, false on failures (the rest of the save-process will be
	 * skipped!), or null when this method is not actived.
	 * @author Oscar van Eijk

	public function plgVmOnUpdateOrderPayment(  $_formData) {
	return null;
	}
	 */
	/**
	 * Save updated orderline data to the method specific table
	 *
	 * @param array $_formData Form data
	 * @return mixed, True on success, false on failures (the rest of the save-process will be
	 * skipped!), or null when this method is not actived.
	 * @author Oscar van Eijk

	public function plgVmOnUpdateOrderLine(  $_formData) {
	return null;
	}
	 */
	/**
	 * plgVmOnEditOrderLineBE
	 * This method is fired when editing the order line details in the backend.
	 * It can be used to add line specific package codes
	 *
	 * @param integer $_orderId The order ID
	 * @param integer $_lineId
	 * @return mixed Null for method that aren't active, text (HTML) otherwise
	 * @author Oscar van Eijk

	public function plgVmOnEditOrderLineBE(  $_orderId, $_lineId) {
	return null;
	}
	 */

	/**
	 * This method is fired when showing the order details in the frontend, for every orderline.
	 * It can be used to display line specific package codes, e.g. with a link to external tracking and
	 * tracing systems
	 *
	 * @param integer $_orderId The order ID
	 * @param integer $_lineId
	 * @return mixed Null for method that aren't active, text (HTML) otherwise
	 * @author Oscar van Eijk

	public function plgVmOnShowOrderLineFE(  $_orderId, $_lineId) {
	return null;
	}
	 */
	function plgVmDeclarePluginParamsPayment ($name, $id, &$data) {

		return $this->declarePluginParams ('payment', $name, $id, $data);
	}

	/**
	 * @param $name
	 * @param $id
	 * @param $table
	 * @return bool
	 */
	function plgVmSetOnTablePluginParamsPayment ($name, $id, &$table) {

		return $this->setOnTablePluginParams ($name, $id, $table);
	}

	
	
	
	
	
}
