<?php
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
/**
 *
 * @package	VirtueMart
 * @subpackage Plugins  - Elements
 * @author Valérie Isaksen, Reinhold Kainhofer
 * @copyright Copyright (c) 2004 - 2011 VirtueMart Team. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.txt
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */
/*
 * This class is used by VirtueMart Payment or Shipment Plugins
 * which uses JParameter
 * So It should be an extension of JElement
 * Those plugins cannot be configured througth the Plugin Manager anyway.
 */
 
 
if (!class_exists('VmConfig'))
    require(JPATH_ROOT . DIRECTORY_SEPARATOR . 'administrator' . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_virtuemart' . DIRECTORY_SEPARATOR . 'helpers' . DIRECTORY_SEPARATOR . 'config.php');

if (!class_exists('ShopFunctions'))
    require(JPATH_VM_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'helpers' . DIRECTORY_SEPARATOR . 'shopfunctions.php');

#[\AllowDynamicProperties]
class JElementVmLengthUnit extends JElement {

    /**
     * Element name
     * @access	protected
     * @var		string
     */
    var $_name = 'LengthUnit';

    function fetchElement($nm, $selected, &$node, $control_name) {
		// For now, this is a modified copy of ShopFunctions::renderLWHUnitList to use HTMLHelper::_ instead of VmHTML 
		// (which would NOT remove the [ and ] from the ID and thus break the javascript magic!)
		if (!class_exists ('VmHTML')) {
			require(JPATH_VM_ADMINISTRATOR . DIRECTORY_SEPARATOR . 'helpers' . DIRECTORY_SEPARATOR . 'html.php');
		}
		$name = $control_name . '[' . $nm . ']';

		$lwh_unit_default = array('M' => Text::_ ('COM_VIRTUEMART_UNIT_NAME_M')
		, 'CM'                        => Text::_ ('COM_VIRTUEMART_UNIT_NAME_CM')
		, 'MM'                        => Text::_ ('COM_VIRTUEMART_UNIT_NAME_MM')
		, 'YD'                        => Text::_ ('COM_VIRTUEMART_UNIT_NAME_YARD')
		, 'FT'                        => Text::_ ('COM_VIRTUEMART_UNIT_NAME_FOOT')
		, 'IN'                        => Text::_ ('COM_VIRTUEMART_UNIT_NAME_INCH')
		);
		foreach ($lwh_unit_default as  $key => $value) {
			$lu_list[] = HTMLHelper::_ ('select.option', $key, $value, $name);
		}
		$listHTML = HTMLHelper::_ ('Select.genericlist', $lu_list, $name, '', $name, 'text', $selected);
		return $listHTML;
    }

}